import 'package:flutter/material.dart';
import 'package:flutter_clean_architecture/flutter_clean_architecture.dart';
import 'package:plantilla/app/pages.dart';
import 'package:plantilla/app/pages/menu_drawer/menu_drawer_presenter.dart';
import 'package:plantilla/data/repositories/mock/data_mock_example_repository.dart';
import 'package:plantilla/domain/entities/example.dart';
import 'package:plantilla/domain/usecases/get_example_usecase.dart';

class MenuDrawerController extends Controller {
  MenuDrawerController(DataMockExamplerepository exampleRepository)
      : presenter = MenuDrawerPresenter(exampleRepository);

  final MenuDrawerPresenter presenter;
  Example? example = Example(greeting: '');

  @override
  void onInitState() {
    // TODO: implement onInitState
    super.onInitState();
    presenter.getGreeting('Hola');
  }

  @override
  void initListeners() {
    presenter.getGreetingOnComplete = () {};
    presenter.getGreetingOnError = (e) {};
    presenter.getGreetingOnNext = getGreetingOnNext;
  }

  void getGreetingOnNext(GetExampleUseCaseResponse response) {
    example = response.example;
    refreshUI();
  }

  void goHeroesPage() {
    Map args = <String, dynamic>{};
    Navigator.pushNamed(
      getContext(),
      Pages.heroePage,
      arguments: args,
    );
  }
}
