import 'package:flutter_clean_architecture/flutter_clean_architecture.dart';
import 'package:plantilla/domain/repositories/example_repository.dart';
import 'package:plantilla/domain/usecases/get_example_usecase.dart';

class MenuDrawerPresenter extends Presenter {
  Function? getGreetingOnNext;
  Function? getGreetingOnError;
  Function? getGreetingOnComplete;

  GetExampleUseCase _getExampleUseCase;

  MenuDrawerPresenter(ExampleRepository exampleRepository)
      : _getExampleUseCase = GetExampleUseCase(exampleRepository);

  @override
  void dispose() {
    _getExampleUseCase.dispose();
  }

  void getGreeting(String greeting) {
    //llamar al observer
    _getExampleUseCase.execute(_GetExampleUseCaseObserver(this),
        GetExampleUseCaseParams(greeting));
  }
}

class _GetExampleUseCaseObserver
    implements Observer<GetExampleUseCaseResponse> {
  final MenuDrawerPresenter presenter;
  _GetExampleUseCaseObserver(this.presenter);

  @override
  void onComplete() {
    assert(presenter.getGreetingOnComplete != null);
    presenter.getGreetingOnComplete!();
  }

  @override
  void onError(e) {
    assert(presenter.getGreetingOnComplete != null);
    presenter.getGreetingOnError!(e);
  }

  @override
  void onNext(GetExampleUseCaseResponse? response) {
    assert(presenter.getGreetingOnComplete != null);
    presenter.getGreetingOnNext!(response);
  }
}
