// lib/app/pages/indicadores/indicadores_controller.dart
import 'package:plantilla/app/pages/indicadores/indicadores_presenter.dart';
import 'package:plantilla/data/repositories/mock/data_mock_example_repository.dart';
import 'package:plantilla/domain/entities/example.dart';

import 'package:flutter_clean_architecture/flutter_clean_architecture.dart';

class IndicadoresController extends Controller {
  final IndicadoresPresenter examplePresenter;

  Example? example;

  IndicadoresController(DataMockExamplerepository dataMockExamplerepository)
    : examplePresenter = IndicadoresPresenter(dataMockExamplerepository),
      super();

  @override
  void onInitState() {
    super.onInitState();
    Future.delayed(Duration(seconds: 2), () {
      examplePresenter.getGreeting('Mundo');
    });
  }

  @override
  void initListeners() {
    examplePresenter.getExampleOnComplete = () {};
    examplePresenter.getExampleOnError = (e) {};
    examplePresenter.getExampleOnNext = (Example response) {
      example = response;
      refreshUI();
    };
  }

  String returnedMsg() {
    if (example == null) {
      return '';
    } else {
      return example!.greeting as String;
    }
  }
}
