// lib/app/pages/indicadores/indicadores_presenter.dart
import 'package:plantilla/domain/repositories/example_repository.dart';
import 'package:plantilla/domain/usecases/get_example_usecase.dart';
import 'package:flutter_clean_architecture/flutter_clean_architecture.dart';

class IndicadoresPresenter extends Presenter {
  Function? getExampleOnComplete;
  Function? getExampleOnError;
  Function? getExampleOnNext;

  GetExampleUseCase _getExampleUseCase;

  IndicadoresPresenter(ExampleRepository exampleRepository)
    : _getExampleUseCase = GetExampleUseCase(exampleRepository);

  @override
  void dispose() {
    _getExampleUseCase.dispose();
  }

  void getGreeting(String greeting) {
    _getExampleUseCase.execute(
      _GetExampleUseCaseObserver(this),
      GetExampleUseCaseParams(greeting),
    );
  }
}

class _GetExampleUseCaseObserver
    implements Observer<GetExampleUseCaseResponse> {
  final IndicadoresPresenter presenter;
  _GetExampleUseCaseObserver(this.presenter);

  @override
  void onComplete() {
    assert(presenter.getExampleOnComplete != null);
    presenter.getExampleOnComplete!();
  }

  @override
  void onError(e) {
    assert(presenter.getExampleOnError != null);
    presenter.getExampleOnError!(e);
  }

  @override
  void onNext(response) {
    assert(presenter.getExampleOnNext != null);
    presenter.getExampleOnNext!(response!.example);
  }
}
