// lib/app/pages/loading/loading_controller.dart
import 'package:plantilla/app/pages/loading/loading_presenter.dart';
import 'package:plantilla/data/repositories/mock/data_mock_example_repository.dart';
import 'package:plantilla/domain/entities/example.dart';

import 'package:flutter_clean_architecture/flutter_clean_architecture.dart';

// Creamos una clase LoadingController extendiendo Controller de Clean Architecture
// Esta clase debe manejar toda la lógica de nuestra pantalla o componente.
class LoadingController extends Controller {
  // Definimos un objeto de clase loadingPresenter
  final LoadingPresenter loadingPresenter;

  // Definimos un objeto Example posiblemente nulo
  Example? example;

  // Creamos el constructor del Controlador
  // Como parámetro de entrada recibimos un repositorio, pueden ser uno o varios
  // incluidos otros tipos de objetos (los que sean necesario).
  // También inicializamos el presenter con el repositorio capturado
  LoadingController(DataMockExamplerepository dataMockExamplerepository)
    : loadingPresenter = LoadingPresenter(dataMockExamplerepository),
      super();

  // Uno de los métodos de Controller, onInitState nos permite llamar o
  // inicializar elementos cuando se cree el estado de inicio de esta pantalla.
  @override
  void onInitState() {
    // Hacemos lo que está por defecto en la clase padre (Controller)
    super.onInitState();
    // Cuando pasen dos segundos, llamaremos al método getGreeting del
    // presenter. Acá no esperamos ningún dato.
    Future.delayed(Duration(seconds: 2), () {
      loadingPresenter.getGreeting('Mundo');
    });
  }

  // en initListeners es donde implementamos las funciones vacías del presenter
  // como su nombre lo dice, implementamos o inicializamos los Listeners,
  // que estarán a la escuchande lo que mande el presenter (Observer).
  @override
  void initListeners() {
    // Cuando se complete, acá no hacemos nada
    loadingPresenter.getExampleOnComplete = () {};
    // Cuando se gatille un error, no hacemos nada
    loadingPresenter.getExampleOnError = (e) {};
    // Cuando obtengamos los datos, se los asignamos al objeto example y
    // refrescaremos la pantalla con refreshUI()
    loadingPresenter.getExampleOnNext = (Example response) {
      example = response;
      refreshUI();
    };
  }

  // método para devolver el mensaje de greeting, sino devolvemos
  // un string vacío. para no causar un error ( hay formas más elegantes de
  // hacerlo).
  String returnedMsg() {
    if (example == null) {
      return '';
    } else {
      return example!.greeting as String;
    }
  }
}
